/*! Capacitor-Community: https://github.com/capacitor-community - MIT License */
var capacitorExports=function(e){"use strict";var t,r,n,i,o,s,a,c,u,l,d,p,h,f;e.CameraSource=void 0,(t=e.CameraSource||(e.CameraSource={})).Prompt="PROMPT",t.Camera="CAMERA",t.Photos="PHOTOS",e.CameraDirection=void 0,(r=e.CameraDirection||(e.CameraDirection={})).Rear="REAR",r.Front="FRONT",e.CameraResultType=void 0,(n=e.CameraResultType||(e.CameraResultType={})).Uri="uri",n.Base64="base64",n.DataUrl="dataUrl",e.FilesystemDirectory=void 0,
/**
         * The Documents directory
         * On iOS it's the app's documents directory.
         * Use this directory to store user-generated content.
         * On Android it's the Public Documents folder, so it's accessible from other apps.
         * It's not accesible on Android 10 unless the app enables legacy External Storage
         * by adding `android:requestLegacyExternalStorage="true"` in the `application` tag
         * in the `AndroidManifest.xml`
         */
(i=e.FilesystemDirectory||(e.FilesystemDirectory={})).Documents="DOCUMENTS",
/**
         * The Data directory
         * On iOS it will use the Documents directory
         * On Android it's the directory holding application files.
         * Files will be deleted when the application is uninstalled.
         */
i.Data="DATA",
/**
         * The Cache directory
         * Can be deleted in cases of low memory, so use this directory to write app-specific files
         * that your app can re-create easily.
         */
i.Cache="CACHE",
/**
         * The external directory
         * On iOS it will use the Documents directory
         * On Android it's the directory on the primary shared/external
         * storage device where the application can place persistent files it owns.
         * These files are internal to the applications, and not typically visible
         * to the user as media.
         * Files will be deleted when the application is uninstalled.
         */
i.External="EXTERNAL",
/**
         * The external storage directory
         * On iOS it will use the Documents directory
         * On Android it's the primary shared/external storage directory.
         * It's not accesible on Android 10 unless the app enables legacy External Storage
         * by adding `android:requestLegacyExternalStorage="true"` in the `application` tag
         * in the `AndroidManifest.xml`
         */
i.ExternalStorage="EXTERNAL_STORAGE",e.FilesystemEncoding=void 0,(o=e.FilesystemEncoding||(e.FilesystemEncoding={})).UTF8="utf8",o.ASCII="ascii",o.UTF16="utf16",e.HapticsImpactStyle=void 0,(s=e.HapticsImpactStyle||(e.HapticsImpactStyle={})).Heavy="HEAVY",s.Medium="MEDIUM",s.Light="LIGHT",e.HapticsNotificationType=void 0,(a=e.HapticsNotificationType||(e.HapticsNotificationType={})).SUCCESS="SUCCESS",a.WARNING="WARNING",a.ERROR="ERROR",e.KeyboardStyle=void 0,(c=e.KeyboardStyle||(e.KeyboardStyle={})).Dark="DARK",c.Light="LIGHT",e.KeyboardResize=void 0,(u=e.KeyboardResize||(e.KeyboardResize={})).Body="body",u.Ionic="ionic",u.Native="native",u.None="none",e.ActionSheetOptionStyle=void 0,(l=e.ActionSheetOptionStyle||(e.ActionSheetOptionStyle={})).Default="DEFAULT",l.Destructive="DESTRUCTIVE",l.Cancel="CANCEL",
e.PermissionType=void 0,(d=e.PermissionType||(e.PermissionType={})).Camera="camera",d.Photos="photos",d.Geolocation="geolocation",d.Notifications="notifications",d.ClipboardRead="clipboard-read",d.ClipboardWrite="clipboard-write",d.Microphone="microphone",e.PhotosAlbumType=void 0,
/**
         * Album is a "smart" album (such as Favorites or Recently Added)
         */
(p=e.PhotosAlbumType||(e.PhotosAlbumType={})).Smart="smart",
/**
         * Album is a cloud-shared album
         */
p.Shared="shared",
/**
         * Album is a user-created album
         */
p.User="user",e.StatusBarStyle=void 0,
/**
         * Light text for dark backgrounds.
         */
(h=e.StatusBarStyle||(e.StatusBarStyle={})).Dark="DARK",
/**
         * Dark text for light backgrounds.
         */
h.Light="LIGHT",e.StatusBarAnimation=void 0,
/**
         * No animation during show/hide.
         */
(f=e.StatusBarAnimation||(e.StatusBarAnimation={})).None="NONE",
/**
         * Slide animation during show/hide.
         */
f.Slide="SLIDE",
/**
         * Fade animation during show/hide.
         */
f.Fade="FADE";
// Create our default Capacitor instance, which will be
// overridden on native platforms
// @ts-ignore
e.Capacitor=new class{constructor(){this.Plugins={},this.platform="electron",this.isNative=!1,
// Build a proxy for the Plugins object that returns the "Noop Plugin"
// if a plugin isn't available
this.Plugins=new Proxy(this.Plugins,{get:(e,t)=>{if(void 0===e[t]){let e=this;return new Proxy({},{get:(r,n)=>void 0===r[n]?e.pluginMethodNoop.bind(e,r,n,t):r[n]})}return e[t]}})}pluginMethodNoop(e,t,r){return Promise.reject(`${r} does not have electron implementation.`)}getPlatform(){return this.platform}isPluginAvailable(e){return this.Plugins.hasOwnProperty(e)}convertFileSrc(e){return e}handleError(e){console.error(e)}},e.Capacitor=window.Capacitor||e.Capacitor,
// Export window.Capacitor if not available already (ex: web)
window.Capacitor||(window.Capacitor=e.Capacitor);const m=e.Capacitor.Plugins;var y,v=/** @class */function(){function e(){var e=this;this.platform="web",this.isNative=!1,
// Need to assign here to avoid having to define every plugin but still
// get the typed benefits of the provided plugins in PluginRegistry
this.Plugins={},
// Gracefully degrade in non-Proxy supporting engines, e.g. IE11. This
// effectively means that trying to access an unavailable plugin will
// locally throw, but this is still better than throwing a syntax error.
"undefined"!=typeof Proxy&&(
// Build a proxy for the Plugins object that returns the "Noop Plugin"
// if a plugin isn't available
this.Plugins=new Proxy(this.Plugins,{get:function(t,r){if(void 0===t[r]){var n=e;return new Proxy({},{get:function(e,t){return void 0===e[t]?n.pluginMethodNoop.bind(n,e,t,r):e[t]}})}return t[r]}}))}return e.prototype.pluginMethodNoop=function(e,t,r){return Promise.reject(r+" does not have web implementation.")},e.prototype.getPlatform=function(){return this.platform},e.prototype.isPluginAvailable=function(e){return this.Plugins.hasOwnProperty(e)},e.prototype.convertFileSrc=function(e){return e},e.prototype.handleError=function(e){console.error(e)},e}(),w=((y=
// figure out the current globalThis, such as "window", "self" or "global"
// ensure errors are not thrown in an node SSR environment or web worker
"undefined"!=typeof self?self:"undefined"!=typeof window?window:"undefined"!=typeof global?global:{}).Capacitor=y.Capacitor||new v).Plugins,g=/** @class */function(){function e(){this.plugins={},this.loadedPlugins={}}return e.prototype.addPlugin=function(e){this.plugins[e.config.name]=e},e.prototype.getPlugin=function(e){return this.plugins[e]},e.prototype.loadPlugin=function(e){var t=this.getPlugin(e);t?t.load():console.error("Unable to load web plugin "+e+", no such plugin found.")},e.prototype.getPlugins=function(){var e=[];for(var t in this.plugins)e.push(this.plugins[t]);return e},e}(),b=new g,P=/** @class */function(){function e(e,t){this.config=e,this.loaded=!1,this.listeners={},this.windowListeners={},t?t.addPlugin(this):b.addPlugin(this)}return e.prototype.addWindowListener=function(e){window.addEventListener(e.windowEventName,e.handler),e.registered=!0},e.prototype.removeWindowListener=function(e){e&&(window.removeEventListener(e.windowEventName,e.handler),e.registered=!1)},e.prototype.addListener=function(e,t){var r=this;this.listeners[e]||(this.listeners[e]=[]),this.listeners[e].push(t);
// If we haven't added a window listener for this event and it requires one,
// go ahead and add it
var n=this.windowListeners[e];return n&&!n.registered&&this.addWindowListener(n),{remove:function(){r.removeListener(e,t)}}},e.prototype.removeListener=function(e,t){var r=this.listeners[e];if(r){var n=r.indexOf(t);this.listeners[e].splice(n,1),
// If there are no more listeners for this type of event,
// remove the window listener
this.listeners[e].length||this.removeWindowListener(this.windowListeners[e])}},e.prototype.removeAllListeners=function(){for(var e in this.listeners={},this.windowListeners)this.removeWindowListener(this.windowListeners[e]);this.windowListeners={}},e.prototype.notifyListeners=function(e,t){var r=this.listeners[e];r&&r.forEach((function(e){return e(t)}))},e.prototype.hasListeners=function(e){return!!this.listeners[e].length},e.prototype.registerWindowListener=function(e,t){var r=this;this.windowListeners[t]={registered:!1,windowEventName:e,pluginEventName:t,handler:function(e){r.notifyListeners(t,e)}}},e.prototype.requestPermissions=function(){return Capacitor.isNative?Capacitor.nativePromise(this.config.name,"requestPermissions",{}):Promise.resolve({results:[]})},e.prototype.load=function(){this.loaded=!0},e}(),S=function(e){for(var t=0,r=b.getPlugins();t<r.length;t++){var n=r[t];E(e,n)}},E=function(e,t){
// If we already have a plugin registered (meaning it was defined in the native layer),
// then we should only overwrite it if the corresponding web plugin activates on
// a certain platform. For example: Geolocation uses the WebPlugin on Android but not iOS
e.hasOwnProperty(t.config.name)&&!function(e){return e.config.platforms&&e.config.platforms.indexOf(Capacitor.platform)>=0}(t)||(e[t.config.name]=t)},x=function(e,t){return(x=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(e,t){e.__proto__=t}||function(e,t){for(var r in t)t.hasOwnProperty(r)&&(e[r]=t[r])})(e,t)};
// Create our default Capacitor instance, which will be
// overridden on native platforms
function C(e,t){function r(){this.constructor=e}x(e,t),e.prototype=null===t?Object.create(t):(r.prototype=t.prototype,new r)}function L(e,t,r,n){return new(r||(r=Promise))((function(i,o){function s(e){try{c(n.next(e))}catch(e){o(e)}}function a(e){try{c(n.throw(e))}catch(e){o(e)}}function c(e){var t;e.done?i(e.value):(t=e.value,t instanceof r?t:new r((function(e){e(t)}))).then(s,a)}c((n=n.apply(e,t||[])).next())}))}function R(e,t){var r,n,i,o,s={label:0,sent:function(){if(1&i[0])throw i[1];return i[1]},trys:[],ops:[]};return o={next:a(0),throw:a(1),return:a(2)},"function"==typeof Symbol&&(o[Symbol.iterator]=function(){return this}),o;function a(o){return function(a){return function(o){if(r)throw new TypeError("Generator is already executing.");for(;s;)try{if(r=1,n&&(i=2&o[0]?n.return:o[0]?n.throw||((i=n.return)&&i.call(n),0):n.next)&&!(i=i.call(n,o[1])).done)return i;switch(n=0,i&&(o=[2&o[0],i.value]),o[0]){case 0:case 1:i=o;break;case 4:return s.label++,{value:o[1],done:!1};case 5:s.label++,n=o[1],o=[0];continue;case 7:o=s.ops.pop(),s.trys.pop();continue;default:if(!(i=s.trys,(i=i.length>0&&i[i.length-1])||6!==o[0]&&2!==o[0])){s=0;continue}if(3===o[0]&&(!i||o[1]>i[0]&&o[1]<i[3])){s.label=o[1];break}if(6===o[0]&&s.label<i[1]){s.label=i[1],i=o;break}if(i&&s.label<i[2]){s.label=i[2],s.ops.push(o);break}i[2]&&s.ops.pop(),s.trys.pop();continue}o=t.call(e,s)}catch(e){o=[6,e],n=0}finally{r=i=0}if(5&o[0])throw o[1];return{value:o[0]?o[1]:void 0,done:!0}}([o,a])}}}new(/** @class */function(e){function t(){return e.call(this,{name:"Accessibility",platforms:["web"]})||this}return C(t,e),t.prototype.isScreenReaderEnabled=function(){throw new Error("Feature not available in the browser")},t.prototype.speak=function(e){if(!("speechSynthesis"in window))return Promise.reject("Browser does not support the Speech Synthesis API");var t=new SpeechSynthesisUtterance(e.value);return e.language&&(t.lang=e.language),window.speechSynthesis.speak(t),Promise.resolve()},t}(P));var F=/** @class */function(e){function t(){var t=e.call(this,{name:"App",platforms:["web"]})||this;return"undefined"!=typeof document&&document.addEventListener("visibilitychange",t.handleVisibilityChange.bind(t),!1),t}return C(t,e),t.prototype.exitApp=function(){throw new Error("Method not implemented.")},t.prototype.canOpenUrl=function(e){return Promise.resolve({value:!0})},t.prototype.openUrl=function(e){return Promise.resolve({completed:!0})},t.prototype.getLaunchUrl=function(){return Promise.resolve({url:""})},t.prototype.getState=function(){return Promise.resolve({isActive:!0!==document.hidden})},t.prototype.handleVisibilityChange=function(){var e={isActive:!0!==document.hidden};this.notifyListeners("appStateChange",e)},t}(P);new F,new(/** @class */function(e){function t(){return e.call(this,{name:"Browser",platforms:["web"]})||this}return C(t,e),t.prototype.open=function(e){return L(this,void 0,void 0,(function(){return R(this,(function(t){return this._lastWindow=window.open(e.url,e.windowName||"_blank"),[2/*return*/,Promise.resolve()]}))}))},t.prototype.prefetch=function(e){return L(this,void 0,void 0,(function(){return R(this,(function(e){
// Does nothing
return[2/*return*/,Promise.resolve()]}))}))},t.prototype.close=function(){return L(this,void 0,void 0,(function(){return R(this,(function(e){return this._lastWindow&&this._lastWindow.close(),[2/*return*/,Promise.resolve()]}))}))},t}(P)),new(/** @class */function(t){function r(){return t.call(this,{name:"Camera",platforms:["web"]})||this}return C(r,t),r.prototype.getPhoto=function(e){return L(this,void 0,void 0,(function(){var t=this;return R(this,(function(r){return[2/*return*/,new Promise((function(r,n){return L(t,void 0,void 0,(function(){var t,i=this;return R(this,(function(o){switch(o.label){case 0:return e.webUseInput?(this.fileInputExperience(e,r),[3/*break*/,7]):[3/*break*/,1];case 1:if(!customElements.get("pwa-camera-modal"))return[3/*break*/,6];t=document.createElement("pwa-camera-modal"),document.body.appendChild(t),o.label=2;case 2:return o.trys.push([2,4,,5]),[4/*yield*/,t.componentOnReady()];case 3:return o.sent(),t.addEventListener("onPhoto",(function(o){return L(i,void 0,void 0,(function(){var i,s;return R(this,(function(a){switch(a.label){case 0:return null!==(i=o.detail)?[3/*break*/,1]:(n("User cancelled photos app"),[3/*break*/,4]);case 1:return i instanceof Error?(n(i.message),[3/*break*/,4]):[3/*break*/,2];case 2:return s=r,[4/*yield*/,this._getCameraPhoto(i,e)];case 3:s.apply(void 0,[a.sent()]),a.label=4;case 4:return t.dismiss(),document.body.removeChild(t),[2/*return*/]}}))}))})),t.present(),[3/*break*/,5];case 4:return o.sent(),this.fileInputExperience(e,r),[3/*break*/,5];case 5:return[3/*break*/,7];case 6:console.error("Unable to load PWA Element 'pwa-camera-modal'. See the docs: https://capacitorjs.com/docs/pwa-elements."),this.fileInputExperience(e,r),o.label=7;case 7:return[2/*return*/]}}))}))}))]}))}))},r.prototype.fileInputExperience=function(t,r){var n=document.querySelector("#_capacitor-camera-input"),i=function(){n.parentNode&&n.parentNode.removeChild(n)};n||((n=document.createElement("input")).id="_capacitor-camera-input",n.type="file",document.body.appendChild(n)),n.accept="image/*",n.capture=!0,t.source===e.CameraSource.Photos||t.source===e.CameraSource.Prompt?n.removeAttribute("capture"):t.direction===e.CameraDirection.Front?n.capture="user":t.direction===e.CameraDirection.Rear&&(n.capture="environment"),n.addEventListener("change",(function(o){var s=n.files[0],a="jpeg";if("image/png"===s.type?a="png":"image/gif"===s.type&&(a="gif"),t.resultType===e.CameraResultType.DataUrl||t.resultType===e.CameraResultType.Base64){var c=new FileReader;c.addEventListener("load",(function(){if(t.resultType===e.CameraResultType.DataUrl)r({dataUrl:c.result,format:a});else if(t.resultType===e.CameraResultType.Base64){var n=c.result.split(",")[1];r({base64String:n,format:a})}i()})),c.readAsDataURL(s)}else r({webPath:URL.createObjectURL(s),format:a}),i()})),n.click()},r.prototype._getCameraPhoto=function(t,r){return new Promise((function(n,i){var o=new FileReader,s=t.type.split("/")[1];r.resultType===e.CameraResultType.Uri?n({webPath:URL.createObjectURL(t),format:s}):(o.readAsDataURL(t),o.onloadend=function(){var t=o.result;r.resultType===e.CameraResultType.DataUrl?n({dataUrl:t,format:s}):n({base64String:t.split(",")[1],format:s})},o.onerror=function(e){i(e)})}))},r}(P)),new(/** @class */function(e){function t(){return e.call(this,{name:"Clipboard",platforms:["web"]})||this}return C(t,e),t.prototype.write=function(e){return L(this,void 0,void 0,(function(){var t,r,n;return R(this,(function(i){switch(i.label){case 0:return navigator.clipboard?void 0!==e.string||e.url?navigator.clipboard.writeText?[4/*yield*/,navigator.clipboard.writeText(void 0!==e.string?e.string:e.url)]:[2/*return*/,Promise.reject("Writting to clipboard not supported in this browser")]:[3/*break*/,2]:[2/*return*/,Promise.reject("Clipboard API not available in this browser")];case 1:return i.sent(),[3/*break*/,10];case 2:if(!e.image)return[3/*break*/,9];if(!navigator.clipboard.write)return[2/*return*/,Promise.reject("Setting images not supported in this browser")];i.label=3;case 3:return i.trys.push([3,7,,8]),[4/*yield*/,fetch(e.image)];case 4:return[4/*yield*/,i.sent().blob()];case 5:return t=i.sent(),r=new ClipboardItem(((n={})[t.type]=t,n)),[4/*yield*/,navigator.clipboard.write([r])];case 6:return i.sent(),[3/*break*/,8];case 7:return i.sent(),[2/*return*/,Promise.reject("Failed to write image")];case 8:return[3/*break*/,10];case 9:return[2/*return*/,Promise.reject("Nothing to write")];case 10:return[2/*return*/,Promise.resolve()]}}))}))},t.prototype.read=function(){return L(this,void 0,void 0,(function(){var e,t,r,n;return R(this,(function(i){switch(i.label){case 0:return navigator.clipboard?navigator.clipboard.read?[3/*break*/,1]:navigator.clipboard.readText?[2/*return*/,this.readText()]:[2/*return*/,Promise.reject("Reading from clipboard not supported in this browser")]:[2/*return*/,Promise.reject("Clipboard API not available in this browser")];case 1:return i.trys.push([1,5,,6]),[4/*yield*/,navigator.clipboard.read()];case 2:return e=i.sent(),t=e[0].types[0],[4/*yield*/,e[0].getType(t)];case 3:return r=i.sent(),[4/*yield*/,this._getBlobData(r,t)];case 4:return n=i.sent(),[2/*return*/,Promise.resolve({value:n,type:t})];case 5:return i.sent(),[2/*return*/,this.readText()];case 6:return[2/*return*/]}}))}))},t.prototype.readText=function(){return L(this,void 0,void 0,(function(){var e;return R(this,(function(t){switch(t.label){case 0:return[4/*yield*/,navigator.clipboard.readText()];case 1:return e=t.sent(),[2/*return*/,Promise.resolve({value:e,type:"text/plain"})]}}))}))},t.prototype._getBlobData=function(e,t){return new Promise((function(r,n){var i=new FileReader;t.includes("image")?i.readAsDataURL(e):i.readAsText(e),i.onloadend=function(){var e=i.result;r(e)},i.onerror=function(e){n(e)}}))},t}(P)),new(/** @class */function(t){function r(){var r=t.call(this,{name:"Filesystem",platforms:["web"]})||this;return r.DEFAULT_DIRECTORY=e.FilesystemDirectory.Data,r.DB_VERSION=1,r.DB_NAME="Disc",r._writeCmds=["add","put","delete"],r}return C(r,t),r.prototype.initDb=function(){return L(this,void 0,void 0,(function(){var e=this;return R(this,(function(t){if(void 0!==this._db)return[2/*return*/,this._db];if(!("indexedDB"in window))throw new Error("This browser doesn't support IndexedDB");return[2/*return*/,new Promise((function(t,n){var i=indexedDB.open(e.DB_NAME,e.DB_VERSION);i.onupgradeneeded=r.doUpgrade,i.onsuccess=function(){e._db=i.result,t(i.result)},i.onerror=function(){return n(i.error)},i.onblocked=function(){console.warn("db blocked")}}))]}))}))},r.doUpgrade=function(e){var t=e.target.result;switch(e.oldVersion){case 0:case 1:default:t.objectStoreNames.contains("FileStorage")&&t.deleteObjectStore("FileStorage"),t.createObjectStore("FileStorage",{keyPath:"path"}).createIndex("by_folder","folder")}},r.prototype.dbRequest=function(e,t){return L(this,void 0,void 0,(function(){var r;return R(this,(function(n){return r=-1!==this._writeCmds.indexOf(e)?"readwrite":"readonly",[2/*return*/,this.initDb().then((function(n){return new Promise((function(i,o){var s=n.transaction(["FileStorage"],r).objectStore("FileStorage"),a=s[e].apply(s,t);a.onsuccess=function(){return i(a.result)},a.onerror=function(){return o(a.error)}}))}))]}))}))},r.prototype.dbIndexRequest=function(e,t,r){return L(this,void 0,void 0,(function(){var n;return R(this,(function(i){return n=-1!==this._writeCmds.indexOf(t)?"readwrite":"readonly",[2/*return*/,this.initDb().then((function(i){return new Promise((function(o,s){var a=i.transaction(["FileStorage"],n).objectStore("FileStorage").index(e),c=a[t].apply(a,r);c.onsuccess=function(){return o(c.result)},c.onerror=function(){return s(c.error)}}))}))]}))}))},r.prototype.getPath=function(e,t){e=e||this.DEFAULT_DIRECTORY;var r=void 0!==t?t.replace(/^[/]+|[/]+$/g,""):"",n="/"+e;return""!==t&&(n+="/"+r),n},r.prototype.clear=function(){return L(this,void 0,void 0,(function(){var e,t;return R(this,(function(r){switch(r.label){case 0:return[4/*yield*/,this.initDb()];case 1:return e=r.sent(),t=e.transaction(["FileStorage"],"readwrite"),t.objectStore("FileStorage").clear(),[2/*return*/,{}]}}))}))},
/**
         * Read a file from disk
         * @param options options for the file read
         * @return a promise that resolves with the read file data result
         */
r.prototype.readFile=function(e){return L(this,void 0,void 0,(function(){var t,r;return R(this,(function(n){switch(n.label){case 0:return t=this.getPath(e.directory,e.path),[4/*yield*/,this.dbRequest("get",[t])];case 1:if(void 0===(r=n.sent()))throw Error("File does not exist.");return[2/*return*/,{data:r.content}]}}))}))},
/**
         * Write a file to disk in the specified location on device
         * @param options options for the file write
         * @return a promise that resolves with the file write result
         */
r.prototype.writeFile=function(e){return L(this,void 0,void 0,(function(){var t,r,n,i,o,s,a,c,u,l;return R(this,(function(d){switch(d.label){case 0:return t=this.getPath(e.directory,e.path),r=e.data,n=e.recursive,[4/*yield*/,this.dbRequest("get",[t])];case 1:if((i=d.sent())&&"directory"===i.type)throw"The supplied path is a directory.";return o=e.encoding,s=t.substr(0,t.lastIndexOf("/")),[4/*yield*/,this.dbRequest("get",[s])];case 2:return void 0!==d.sent()||-1===(a=s.indexOf("/",1))?[3/*break*/,4]:(c=s.substr(a),[4/*yield*/,this.mkdir({path:c,directory:e.directory,recursive:n})]);case 3:d.sent(),d.label=4;case 4:return u=Date.now(),l={path:t,folder:s,type:"file",size:r.length,ctime:u,mtime:u,content:!o&&r.indexOf(",")>=0?r.split(",")[1]:r},[4/*yield*/,this.dbRequest("put",[l])];case 5:return d.sent(),[2/*return*/,{uri:l.path}]}}))}))},
/**
         * Append to a file on disk in the specified location on device
         * @param options options for the file append
         * @return a promise that resolves with the file write result
         */
r.prototype.appendFile=function(e){return L(this,void 0,void 0,(function(){var t,r,n,i,o,s,a,c,u;return R(this,(function(l){switch(l.label){case 0:return t=this.getPath(e.directory,e.path),r=e.data,n=t.substr(0,t.lastIndexOf("/")),i=Date.now(),o=i,[4/*yield*/,this.dbRequest("get",[t])];case 1:if((s=l.sent())&&"directory"===s.type)throw"The supplied path is a directory.";return[4/*yield*/,this.dbRequest("get",[n])];case 2:return void 0!==l.sent()||-1===(a=n.indexOf("/",1))?[3/*break*/,4]:(c=n.substr(a),[4/*yield*/,this.mkdir({path:c,directory:e.directory,recursive:!0})]);case 3:l.sent(),l.label=4;case 4:return void 0!==s&&(r=s.content+r,o=s.ctime),u={path:t,folder:n,type:"file",size:r.length,ctime:o,mtime:i,content:r},[4/*yield*/,this.dbRequest("put",[u])];case 5:return l.sent(),[2/*return*/,{}]}}))}))},
/**
         * Delete a file from disk
         * @param options options for the file delete
         * @return a promise that resolves with the deleted file data result
         */
r.prototype.deleteFile=function(e){return L(this,void 0,void 0,(function(){var t;return R(this,(function(r){switch(r.label){case 0:return t=this.getPath(e.directory,e.path),[4/*yield*/,this.dbRequest("get",[t])];case 1:if(void 0===r.sent())throw Error("File does not exist.");return[4/*yield*/,this.dbIndexRequest("by_folder","getAllKeys",[IDBKeyRange.only(t)])];case 2:if(0!==r.sent().length)throw Error("Folder is not empty.");return[4/*yield*/,this.dbRequest("delete",[t])];case 3:return r.sent(),[2/*return*/,{}]}}))}))},
/**
         * Create a directory.
         * @param options options for the mkdir
         * @return a promise that resolves with the mkdir result
         */
r.prototype.mkdir=function(e){return L(this,void 0,void 0,(function(){var t,r,n,i,o,s,a,c,u;return R(this,(function(l){switch(l.label){case 0:return t=this.getPath(e.directory,e.path),r=e.recursive,n=t.substr(0,t.lastIndexOf("/")),i=(t.match(/\//g)||[]).length,[4/*yield*/,this.dbRequest("get",[n])];case 1:return o=l.sent(),[4/*yield*/,this.dbRequest("get",[t])];case 2:if(s=l.sent(),1===i)throw Error("Cannot create Root directory");if(void 0!==s)throw Error("Current directory does already exist.");if(!r&&2!==i&&void 0===o)throw Error("Parent directory must exist");return r&&2!==i&&void 0===o?(a=n.substr(n.indexOf("/",1)),[4/*yield*/,this.mkdir({path:a,directory:e.directory,recursive:r})]):[3/*break*/,4];case 3:l.sent(),l.label=4;case 4:return c=Date.now(),u={path:t,folder:n,type:"directory",size:0,ctime:c,mtime:c},[4/*yield*/,this.dbRequest("put",[u])];case 5:return l.sent(),[2/*return*/,{}]}}))}))},
/**
         * Remove a directory
         * @param options the options for the directory remove
         */
r.prototype.rmdir=function(e){return L(this,void 0,void 0,(function(){var t,r,n,i,o,s,a,c,u,l;return R(this,(function(d){switch(d.label){case 0:return t=e.path,r=e.directory,n=e.recursive,i=this.getPath(r,t),[4/*yield*/,this.dbRequest("get",[i])];case 1:if(void 0===(o=d.sent()))throw Error("Folder does not exist.");if("directory"!==o.type)throw Error("Requested path is not a directory");return[4/*yield*/,this.readdir({path:t,directory:r})];case 2:if(0!==(s=d.sent()).files.length&&!n)throw Error("Folder is not empty");a=0,c=s.files,d.label=3;case 3:return a<c.length?(u=c[a],l=t+"/"+u,[4/*yield*/,this.stat({path:l,directory:r})]):[3/*break*/,9];case 4:return"file"!==d.sent().type?[3/*break*/,6]:[4/*yield*/,this.deleteFile({path:l,directory:r})];case 5:return d.sent(),[3/*break*/,8];case 6:return[4/*yield*/,this.rmdir({path:l,directory:r,recursive:n})];case 7:d.sent(),d.label=8;case 8:return a++,[3/*break*/,3];case 9:return[4/*yield*/,this.dbRequest("delete",[i])];case 10:return d.sent(),[2/*return*/,{}]}}))}))},
/**
         * Return a list of files from the directory (not recursive)
         * @param options the options for the readdir operation
         * @return a promise that resolves with the readdir directory listing result
         */
r.prototype.readdir=function(e){return L(this,void 0,void 0,(function(){var t,r,n;return R(this,(function(i){switch(i.label){case 0:return t=this.getPath(e.directory,e.path),[4/*yield*/,this.dbRequest("get",[t])];case 1:if(r=i.sent(),""!==e.path&&void 0===r)throw Error("Folder does not exist.");return[4/*yield*/,this.dbIndexRequest("by_folder","getAllKeys",[IDBKeyRange.only(t)])];case 2:return n=i.sent(),[2/*return*/,{files:n.map((function(e){return e.substring(t.length+1)}))}]}}))}))},
/**
         * Return full File URI for a path and directory
         * @param options the options for the stat operation
         * @return a promise that resolves with the file stat result
         */
r.prototype.getUri=function(e){return L(this,void 0,void 0,(function(){var t,r;return R(this,(function(n){switch(n.label){case 0:return t=this.getPath(e.directory,e.path),[4/*yield*/,this.dbRequest("get",[t])];case 1:return void 0!==(r=n.sent())?[3/*break*/,3]:[4/*yield*/,this.dbRequest("get",[t+"/"])];case 2:r=n.sent(),n.label=3;case 3:if(void 0===r)throw Error("Entry does not exist.");return[2/*return*/,{uri:r.path}]}}))}))},
/**
         * Return data about a file
         * @param options the options for the stat operation
         * @return a promise that resolves with the file stat result
         */
r.prototype.stat=function(e){return L(this,void 0,void 0,(function(){var t,r;return R(this,(function(n){switch(n.label){case 0:return t=this.getPath(e.directory,e.path),[4/*yield*/,this.dbRequest("get",[t])];case 1:return void 0!==(r=n.sent())?[3/*break*/,3]:[4/*yield*/,this.dbRequest("get",[t+"/"])];case 2:r=n.sent(),n.label=3;case 3:if(void 0===r)throw Error("Entry does not exist.");return[2/*return*/,{type:r.type,size:r.size,ctime:r.ctime,mtime:r.mtime,uri:r.path}]}}))}))},
/**
         * Rename a file or directory
         * @param options the options for the rename operation
         * @return a promise that resolves with the rename result
         */
r.prototype.rename=function(e){return L(this,void 0,void 0,(function(){return R(this,(function(t){return[2/*return*/,this._copy(e,!0)]}))}))},
/**
         * Copy a file or directory
         * @param options the options for the copy operation
         * @return a promise that resolves with the copy result
         */
r.prototype.copy=function(e){return L(this,void 0,void 0,(function(){return R(this,(function(t){return[2/*return*/,this._copy(e,!1)]}))}))},
/**
         * Function that can perform a copy or a rename
         * @param options the options for the rename operation
         * @param doRename whether to perform a rename or copy operation
         * @return a promise that resolves with the result
         */
r.prototype._copy=function(e,t){return void 0===t&&(t=!1),L(this,void 0,void 0,(function(){var r,n,i,o,s,a,c,u,l,d,p,h,f,m,y,v,w=this;return R(this,(function(g){switch(g.label){case 0:if(r=e.to,n=e.from,i=e.directory,o=e.toDirectory,!r||!n)throw Error("Both to and from must be provided");
// If no "to" directory is provided, use the "from" directory
// Test that the "to" and "from" locations are different
if(o||(o=i),s=this.getPath(i,n),a=this.getPath(o,r),s===a)return[2/*return*/,{}];if(a.startsWith(s))throw Error("To path cannot contain the from path");g.label=1;case 1:return g.trys.push([1,3,,6]),[4/*yield*/,this.stat({path:r,directory:o})];case 2:return c=g.sent(),[3/*break*/,6];case 3:return g.sent(),(u=r.split("/")).pop(),l=u.join("/"),u.length>0?[4/*yield*/,this.stat({path:l,directory:o})]:[3/*break*/,5];case 4:if("directory"!==g.sent().type)throw new Error("Parent directory of the to path is a file");g.label=5;case 5:return[3/*break*/,6];case 6:
// Cannot overwrite a directory
if(c&&"directory"===c.type)throw new Error("Cannot overwrite a directory with a file");return[4/*yield*/,this.stat({path:n,directory:i})];case 7:switch(d=g.sent(),p=function(e,t,r){return L(w,void 0,void 0,(function(){var n,i;return R(this,(function(s){switch(s.label){case 0:return n=this.getPath(o,e),[4/*yield*/,this.dbRequest("get",[n])];case 1:return(i=s.sent()).ctime=t,i.mtime=r,[4/*yield*/,this.dbRequest("put",[i])];case 2:return s.sent(),[2/*return*/]}}))}))},d.type){case"file":return[3/*break*/,8];case"directory":return[3/*break*/,15]}return[3/*break*/,28];case 8:return[4/*yield*/,this.readFile({path:n,directory:i})];case 9:return h=g.sent(),t?[4/*yield*/,this.deleteFile({path:n,directory:i})]:[3/*break*/,11];case 10:g.sent(),g.label=11;case 11:
// Write the file to the new location
return[4/*yield*/,this.writeFile({path:r,directory:o,data:h.data})];case 12:
// Write the file to the new location
return g.sent(),t?[4/*yield*/,p(r,d.ctime,d.mtime)]:[3/*break*/,14];case 13:g.sent(),g.label=14;case 14:
// Resolve promise
return[2/*return*/,{}];case 15:if(c)throw Error("Cannot move a directory over an existing object");g.label=16;case 16:
// Create the to directory
return g.trys.push([16,20,,21]),[4/*yield*/,this.mkdir({path:r,directory:o,recursive:!1})];case 17:
// Create the to directory
return g.sent(),t?[4/*yield*/,p(r,d.ctime,d.mtime)]:[3/*break*/,19];case 18:g.sent(),g.label=19;case 19:return[3/*break*/,21];case 20:return g.sent(),[3/*break*/,21];case 21:return[4/*yield*/,this.readdir({path:n,directory:i})];case 22:f=g.sent().files,m=0,y=f,g.label=23;case 23:return m<y.length?(v=y[m],[4/*yield*/,this._copy({from:n+"/"+v,to:r+"/"+v,directory:i,toDirectory:o},t)]):[3/*break*/,26];case 24:
// Move item from the from directory to the to directory
g.sent(),g.label=25;case 25:return m++,[3/*break*/,23];case 26:return t?[4/*yield*/,this.rmdir({path:n,directory:i})]:[3/*break*/,28];case 27:g.sent(),g.label=28;case 28:return[2/*return*/,{}]}}))}))},r._debug=!0,r}(P));var O=function(e){for(var t=[],r=1;r<arguments.length;r++)t[r-1]=arguments[r];return t.forEach((function(t){if(t&&"object"==typeof t)for(var r in t)t.hasOwnProperty(r)&&(e[r]=t[r])})),e};new(/** @class */function(e){function t(){return e.call(this,{name:"Geolocation",platforms:["web"]})||this}return C(t,e),t.prototype.getCurrentPosition=function(e){var t=this;return new Promise((function(r,n){return t.requestPermissions().then((function(t){window.navigator.geolocation.getCurrentPosition((function(e){r(e)}),(function(e){n(e)}),O({enableHighAccuracy:!0,timeout:1e4,maximumAge:0},e))}))}))},t.prototype.watchPosition=function(e,t){return""+window.navigator.geolocation.watchPosition((function(e){t(e)}),(function(e){t(null,e)}),O({enableHighAccuracy:!0,timeout:1e4,maximumAge:0},e))},t.prototype.clearWatch=function(e){return window.navigator.geolocation.clearWatch(parseInt(e.id,10)),Promise.resolve()},t}(P));var T=/** @class */function(e){function t(){return e.call(this,{name:"Device",platforms:["web"]})||this}return C(t,e),t.prototype.getInfo=function(){return L(this,void 0,void 0,(function(){var e,t;return R(this,(function(r){return e=navigator.userAgent,t=this.parseUa(e),[2/*return*/,Promise.resolve({model:t.model,platform:"web",appVersion:"",appBuild:"",appId:"",appName:"",operatingSystem:t.operatingSystem,osVersion:t.osVersion,manufacturer:navigator.vendor,isVirtual:!1,uuid:this.getUid()})]}))}))},t.prototype.getBatteryInfo=function(){return L(this,void 0,void 0,(function(){var e;return R(this,(function(t){switch(t.label){case 0:e={},t.label=1;case 1:return t.trys.push([1,3,,4]),[4/*yield*/,navigator.getBattery()];case 2:return e=t.sent(),[3/*break*/,4];case 3:return t.sent(),[3/*break*/,4];case 4:return[2/*return*/,Promise.resolve({batteryLevel:e.level,isCharging:e.charging})]}}))}))},t.prototype.getLanguageCode=function(){return L(this,void 0,void 0,(function(){return R(this,(function(e){return[2/*return*/,{value:navigator.language}]}))}))},t.prototype.parseUa=function(e){var t={},r=e.indexOf("(")+1,n=e.indexOf(") AppleWebKit");-1!==e.indexOf(") Gecko")&&(n=e.indexOf(") Gecko"));var i=e.substring(r,n);if(-1!==e.indexOf("Android"))t.model=i.replace("; wv","").split("; ").pop().split(" Build")[0],t.osVersion=i.split("; ")[1];else if(t.model=i.split("; ")[0],navigator.oscpu)t.osVersion=navigator.oscpu;else if(-1!==e.indexOf("Windows"))t.osVersion=i;else{var o=i.split("; ").pop().replace(" like Mac OS X","").split(" ");t.osVersion=o[o.length-1].replace(/_/g,".")}return/android/i.test(e)?t.operatingSystem="android":/iPad|iPhone|iPod/.test(e)&&!window.MSStream?t.operatingSystem="ios":/Win/.test(e)?t.operatingSystem="windows":/Mac/i.test(e)?t.operatingSystem="mac":t.operatingSystem="unknown",t},t.prototype.getUid=function(){var e=window.localStorage.getItem("_capuid");return e||(e="xxxxxxxx-xxxx-4xxx-yxxx-xxxxxxxxxxxx".replace(/[xy]/g,(function(e){var t=16*Math.random()|0;return("x"===e?t:3&t|8).toString(16)})),window.localStorage.setItem("_capuid",e),e)},t}(P);new T,new(/** @class */function(e){function t(){var t=e.call(this,{name:"LocalNotifications",platforms:["web"]})||this;return t.pending=[],t}return C(t,e),t.prototype.createChannel=function(e){throw new Error("Feature not available in the browser. "+e.id)},t.prototype.deleteChannel=function(e){throw new Error("Feature not available in the browser. "+e.id)},t.prototype.listChannels=function(){throw new Error("Feature not available in the browser")},t.prototype.sendPending=function(){var e=this,t=[],r=+new Date;this.pending.forEach((function(n){n.schedule&&n.schedule.at&&+n.schedule.at<=r&&(e.buildNotification(n),t.push(n))})),console.log("Sent pending, removing",t),this.pending=this.pending.filter((function(e){return!t.find((function(t){return t===e}))}))},t.prototype.sendNotification=function(e){var t=this,r=e;if(e.schedule&&e.schedule.at){var n=+e.schedule.at-+new Date;return this.pending.push(r),void setTimeout((function(){t.sendPending()}),n)}this.buildNotification(e)},t.prototype.buildNotification=function(e){var t=e;return new Notification(t.title,{body:t.body})},t.prototype.schedule=function(e){var t=this,r=[];return e.notifications.forEach((function(e){r.push(t.sendNotification(e))})),Promise.resolve({notifications:e.notifications.map((function(e){return{id:""+e.id}}))})},t.prototype.getPending=function(){return Promise.resolve({notifications:this.pending.map((function(e){return{id:""+e.id}}))})},t.prototype.registerActionTypes=function(e){throw new Error("Method not implemented.")},t.prototype.cancel=function(e){return console.log("Cancel these",e),this.pending=this.pending.filter((function(t){return!e.notifications.find((function(e){return e.id===""+t.id}))})),Promise.resolve()},t.prototype.areEnabled=function(){return Promise.resolve({value:"granted"===Notification.permission})},t.prototype.requestPermission=function(){return new Promise((function(e){Notification.requestPermission((function(t){var r=!0;"denied"!==t&&"default"!==t||(r=!1),e({granted:r})}))}))},t.prototype.requestPermissions=function(){return new Promise((function(e,t){Notification.requestPermission((function(r){"denied"!==r&&"default"!==r?e({results:[r]}):t(r)}))}))},t}(P)),new(/** @class */function(e){function t(){return e.call(this,{name:"Share",platforms:["web"]})||this}return C(t,e),t.prototype.share=function(e){return navigator.share?navigator.share({title:e.title,text:e.text,url:e.url}):Promise.reject("Web Share API not available")},t}(P));var D=/** @class */function(e){function t(){return e.call(this,{name:"Modals",platforms:["web"]})||this}return C(t,e),t.prototype.alert=function(e){return L(this,void 0,void 0,(function(){return R(this,(function(t){return window.alert(e.message),[2/*return*/,Promise.resolve()]}))}))},t.prototype.prompt=function(e){return L(this,void 0,void 0,(function(){var t;return R(this,(function(r){return t=window.prompt(e.message,e.inputText||""),[2/*return*/,Promise.resolve({value:t,cancelled:null===t})]}))}))},t.prototype.confirm=function(e){return L(this,void 0,void 0,(function(){var t;return R(this,(function(r){return t=window.confirm(e.message),[2/*return*/,Promise.resolve({value:t})]}))}))},t.prototype.showActions=function(e){return L(this,void 0,void 0,(function(){var t=this;return R(this,(function(r){return[2/*return*/,new Promise((function(r,n){return L(t,void 0,void 0,(function(){var t,n=this;return R(this,(function(i){return(t=document.querySelector("pwa-action-sheet"))||(t=document.createElement("pwa-action-sheet"),document.body.appendChild(t)),t.header=e.title,t.cancelable=!1,t.options=e.options,t.addEventListener("onSelection",(function(e){return L(n,void 0,void 0,(function(){var t;return R(this,(function(n){return t=e.detail,r({index:t}),[2/*return*/]}))}))})),[2/*return*/]}))}))}))]}))}))},t}(P);new D,new(/** @class */function(e){function t(){var t=e.call(this,{name:"Motion"})||this;return t.registerWindowListener("devicemotion","accel"),t.registerWindowListener("deviceorientation","orientation"),t}return C(t,e),t}(P)),new(/** @class */function(e){function t(){var t=e.call(this,{name:"Network",platforms:["web"]})||this;return t.listenerFunction=null,t}return C(t,e),t.prototype.getStatus=function(){return new Promise((function(e,t){if(window.navigator){var r=window.navigator.onLine,n=window.navigator.connection||window.navigator.mozConnection||window.navigator.webkitConnection,i=n?n.type||n.effectiveType:"wifi";e({connected:r,connectionType:r?i:"none"})}else t("Network info not available")}))},t.prototype.addListener=function(e,t){var r=window.navigator.connection||window.navigator.mozConnection||window.navigator.webkitConnection,n=r?r.type||r.effectiveType:"wifi",i=t.bind(this,{connected:!0,connectionType:n}),o=t.bind(this,{connected:!1,connectionType:"none"});if(0===e.localeCompare("networkStatusChange"))return window.addEventListener("online",i),window.addEventListener("offline",o),{remove:function(){window.removeEventListener("online",i),window.removeEventListener("offline",o)}}},t}(P)),new(/** @class */function(t){function r(){return t.call(this,{name:"Permissions"})||this}return C(r,t),r.prototype.query=function(t){return L(this,void 0,void 0,(function(){var r,n;return R(this,(function(i){switch(i.label){case 0:return(r=window.navigator).permissions?(n=t.name===e.PermissionType.Photos?"camera":t.name,[4/*yield*/,r.permissions.query({name:n})]):[2/*return*/,Promise.reject("This browser does not support the Permissions API")];case 1:return[2/*return*/,{state:i.sent().state}]}}))}))},r}(P)),new(/** @class */function(e){function t(){return e.call(this,{name:"SplashScreen",platforms:["web"]})||this}return C(t,e),t.prototype.show=function(e,t){return Promise.resolve()},t.prototype.hide=function(e,t){return Promise.resolve()},t}(P)),new(/** @class */function(e){function t(){var t=e.call(this,{name:"Storage",platforms:["web"]})||this;return t.KEY_PREFIX="_cap_",t}return C(t,e),t.prototype.get=function(e){var t=this;return new Promise((function(r,n){r({value:window.localStorage.getItem(t.makeKey(e.key))})}))},t.prototype.set=function(e){var t=this;return new Promise((function(r,n){window.localStorage.setItem(t.makeKey(e.key),e.value),r()}))},t.prototype.remove=function(e){var t=this;return new Promise((function(r,n){window.localStorage.removeItem(t.makeKey(e.key)),r()}))},t.prototype.keys=function(){var e=this;return new Promise((function(t,r){t({keys:Object.keys(localStorage).filter((function(t){return e.isKey(t)})).map((function(t){return e.getKey(t)}))})}))},t.prototype.clear=function(){var e=this;return new Promise((function(t,r){Object.keys(localStorage).filter((function(t){return e.isKey(t)})).forEach((function(e){return window.localStorage.removeItem(e)})),t()}))},t.prototype.makeKey=function(e){return this.KEY_PREFIX+e},t.prototype.isKey=function(e){return 0===e.indexOf(this.KEY_PREFIX)},t.prototype.getKey=function(e){return e.substr(this.KEY_PREFIX.length)},t}(P)),new(/** @class */function(e){function t(){return e.call(this,{name:"Toast",platforms:["web"]})||this}return C(t,e),t.prototype.show=function(e){return L(this,void 0,void 0,(function(){var t,r;return R(this,(function(n){return t=2e3,e.duration&&(t="long"===e.duration?3500:2e3),(r=document.createElement("pwa-toast")).duration=t,r.message=e.text,document.body.appendChild(r),[2/*return*/]}))}))},t}(P)),S(w);const{remote:N,shell:A,ipcRenderer:k}=require("electron"),I=new F;class _ extends P{constructor(){super({name:"App",platforms:["electron"]}),this.launchUrl={url:""},this.listeners={},this.windowListeners={},
// @ts-ignore
k.on("appUrlOpen",((e,t)=>{this.launchUrl={url:t},this.notifyListeners("appUrlOpen",{url:t})}))}exitApp(){let e=N.getCurrentWindow();throw e&&e.close(),new Error("App quit")}canOpenUrl(e){return Promise.resolve({value:!0})}openUrl(e){return A.openExternal(e.url),Promise.resolve({completed:!0})}getLaunchUrl(){return Promise.resolve(this.launchUrl)}getState(){return I.getState()}}const U=new _,{clipboard:j,nativeImage:q}=require("electron");class B extends P{constructor(){super({name:"Clipboard",platforms:["electron"]})}async write(e){return new Promise((t=>{if(void 0!==e.string)j.writeText(e.string);else if(e.url)j.write({text:e.url,bookmark:e.label||""});else if(e.image){const t=e.image;j.write({image:q.createFromDataURL(t)})}return t()}))}async read(){return new Promise((e=>{const t=j.availableFormats();if(!(t.length>0))return e({value:"",type:"text/plain"});{let r=t[t.length-1];if(r.includes("image"))return e({value:j.readImage().toDataURL(),type:r});if(r=t[0],void 0===r)return e({value:"",type:"text/plain"});if("text/plain"===r)return e({value:j.readText(),type:r});if("text/html"===r)return e({value:j.readHTML(),type:r})}}))}}const M=new B,{app:W}=require("electron").remote,K=new T;class V extends P{constructor(){super({name:"Device",platforms:["electron"]})}async getInfo(){var e=await K.getInfo();return{appId:e.appId,appName:e.appName,model:e.model,platform:"electron",appVersion:W.getVersion(),appBuild:"",operatingSystem:e.operatingSystem,osVersion:e.osVersion,manufacturer:navigator.vendor,isVirtual:!1,uuid:e.uuid}}async getBatteryInfo(){var e=await K.getBatteryInfo();return{batteryLevel:e.batteryLevel,isCharging:e.isCharging}}async getLanguageCode(){return K.getLanguageCode()}}const H=new V;class z extends P{constructor(){super({name:"Filesystem",platforms:["electron"]}),this.NodeFS=null,this.fileLocations=null,this.Path=null,this.fileLocations={DRIVE_ROOT:"",DOCUMENTS:""};let t=require("path"),r=require("os");"win32"==r.platform?this.fileLocations.DRIVE_ROOT=process.cwd().split(t.sep)[0]:this.fileLocations.DRIVE_ROOT="/",this.fileLocations[e.FilesystemDirectory.Documents]=t.join(r.homedir(),"Documents")+t.sep,this.NodeFS=require("fs"),this.Path=t}readFile(e){return new Promise(((t,r)=>{-1===Object.keys(this.fileLocations).indexOf(e.directory)&&r(`${e.directory} is currently not supported in the Electron implementation.`);let n=this.fileLocations[e.directory]+e.path;this.NodeFS.readFile(n,e.encoding||"binary",((n,i)=>{n?r(n):t({data:e.encoding?i:Buffer.from(i,"binary").toString("base64")})}))}))}writeFile(e){return new Promise(((t,r)=>{-1===Object.keys(this.fileLocations).indexOf(e.directory)&&r(`${e.directory} is currently not supported in the Electron implementation.`);let n=this.fileLocations[e.directory]+e.path,i=e.data;if(!e.encoding){const t=e.data.indexOf(",")>=0?e.data.split(",")[1]:e.data;i=Buffer.from(t,"base64")}const o=this.Path.dirname(n);this.NodeFS.stat(o,(s=>{if(s){const t=e.recursive;t&&this.NodeFS.mkdirSync(o,{recursive:t})}this.NodeFS.writeFile(n,i,e.encoding||"binary",(e=>{e?r(e):t({uri:n})}))}))}))}appendFile(e){return new Promise(((t,r)=>{-1===Object.keys(this.fileLocations).indexOf(e.directory)&&r(`${e.directory} is currently not supported in the Electron implementation.`);let n=this.fileLocations[e.directory]+e.path,i=e.data;if(!e.encoding){const t=e.data.indexOf(",")>=0?e.data.split(",")[1]:e.data;i=Buffer.from(t,"base64")}this.NodeFS.appendFile(n,i,e.encoding||"binary",(e=>{e?r(e):t()}))}))}deleteFile(e){return new Promise(((t,r)=>{-1===Object.keys(this.fileLocations).indexOf(e.directory)&&r(`${e.directory} directory is currently not supported in the Electron implementation.`);let n=this.fileLocations[e.directory]+e.path;this.NodeFS.unlink(n,(e=>{e?r(e):t()}))}))}mkdir(e){return new Promise(((t,r)=>{-1===Object.keys(this.fileLocations).indexOf(e.directory)&&r(`${e.directory} is currently not supported in the Electron implementation.`);let n=this.fileLocations[e.directory]+e.path;const i=e.recursive;this.NodeFS.mkdir(n,{recursive:i},(e=>{e?r(e):t()}))}))}rmdir(e){let{path:t,directory:r,recursive:n}=e;return-1===Object.keys(this.fileLocations).indexOf(r)?Promise.reject(`${r} is currently not supported in the Electron implementation.`):this.stat({path:t,directory:r}).then((e=>"directory"===e.type?this.readdir({path:t,directory:r}).then((e=>0===e.files.length||n?e.files.length?Promise.all(e.files.map((e=>this.rmdir({path:this.Path.join(t,e),directory:r,recursive:n})))).then((()=>this.rmdir({path:t,directory:r,recursive:n}))):new Promise(((e,n)=>{let i=this.fileLocations[r]+t;this.NodeFS.rmdir(i,(t=>{t?n(t):e()}))})):Promise.reject(`${t} is not empty.`))):this.deleteFile({path:t,directory:r})))}readdir(e){return new Promise(((t,r)=>{-1===Object.keys(this.fileLocations).indexOf(e.directory)&&r(`${e.directory} is currently not supported in the Electron implementation.`);let n=this.fileLocations[e.directory]+e.path;this.NodeFS.readdir(n,((e,n)=>{e?r(e):t({files:n})}))}))}getUri(e){return new Promise(((t,r)=>{-1===Object.keys(this.fileLocations).indexOf(e.directory)&&r(`${e.directory} directory is currently not supported in the Electron implementation.`),t({uri:this.fileLocations[e.directory]+e.path})}))}stat(e){return new Promise(((t,r)=>{-1===Object.keys(this.fileLocations).indexOf(e.directory)&&r(`${e.directory} is currently not supported in the Electron implementation.`);let n=this.fileLocations[e.directory]+e.path;this.NodeFS.stat(n,((e,i)=>{e?r(e):t({type:i.isDirectory()?"directory":i.isFile()?"file":"Not available",size:i.size,ctime:i.ctimeMs,mtime:i.mtimeMs,uri:n})}))}))}_copy(e,t=!1){const r=(e,t)=>new Promise(((n,i)=>{this.NodeFS.stat(e,((o,s)=>{if(o)return void i(o);if(s.isDirectory())return void this.NodeFS.mkdir(t,(o=>{if(o)return void i(o);const s=this.NodeFS.readdirSync(e);Promise.all(s.map((n=>r(e+this.Path.sep+n,t+this.Path.sep+n)))).then((()=>n())).catch(i)}));const a=this.Path.dirname(t).split(this.Path.sep).pop();this.NodeFS.stat(a,(r=>{r&&this.NodeFS.mkdirSync(a),this.NodeFS.copyFile(e,t,(e=>{e?i(e):n()}))}))}))}));return new Promise(((n,i)=>{if(!e.from||!e.to)return void i("Both to and from must be supplied");if(e.toDirectory||(e.toDirectory=e.directory),-1===Object.keys(this.fileLocations).indexOf(e.directory))return void i(`${e.directory} is currently not supported in the Electron implementation.`);if(-1===Object.keys(this.fileLocations).indexOf(e.toDirectory))return void i(`${e.toDirectory} is currently not supported in the Electron implementation.`);const o=this.fileLocations[e.directory]+e.from,s=this.fileLocations[e.toDirectory]+e.to;t?this.NodeFS.rename(o,s,(e=>{e?i(e):n()})):r(o,s).then((()=>n())).catch(i)}))}copy(e){return this._copy(e,!1)}rename(e){return this._copy(e,!0)}}const $=new z,G=new D,{dialog:X,getCurrentWindow:Y}=require("electron").remote;class J extends P{constructor(){super({name:"Modals",platforms:["electron"]})}async alert(e){const t=[e.buttonTitle||"OK"];await X.showMessageBox(Y(),{message:e.message,title:e.title,buttons:t})}async prompt(e){const t=window.prompt(e.message,e.inputText||"");return Promise.resolve({value:t,cancelled:null===t})}async confirm(e){const t=[e.okButtonTitle||"OK",e.cancelButtonTitle||"Cancel"];return{value:0===(await X.showMessageBox(Y(),{message:e.message,title:e.title,buttons:t})).response}}async showActions(e){return G.showActions(e)}}const Q=new J;class Z extends P{constructor(){super({name:"Network",platforms:["electron"]}),this.listenerFunction=null}getStatus(){return new Promise(((e,t)=>{if(!window.navigator)return void t("Network info not available");let r=window.navigator.onLine,n=window.navigator.connection||window.navigator.mozConnection||window.navigator.webkitConnection,i="wifi";n&&(i=n.type),e({connected:r,connectionType:r?i:"none"})}))}addListener(e,t){let r=window.navigator.connection||window.navigator.mozConnection||window.navigator.webkitConnection,n="wifi";r&&(n=r.type);let i=t.bind(this,{connected:!0,connectionType:n}),o=t.bind(this,{connected:!1,connectionType:"none"});if(0===e.localeCompare("networkStatusChange"))return window.addEventListener("online",i),window.addEventListener("offline",o),{remove:()=>{window.removeEventListener("online",i),window.removeEventListener("offline",o)}}}}const ee=new Z;class te extends P{constructor(){super({name:"SplashScreen",platforms:["electron"]}),this.ipc=null,this.ipc=require("electron").ipcRenderer}async show(e,t){this.ipc.send("showCapacitorSplashScreen",Object.assign({},e)),t&&t()}async hide(e,t){this.ipc.send("hideCapacitorSplashScreen",Object.assign({},e)),t&&t()}}const re=new te;S(m);return e.App=U,e.AppPluginElectron=_,e.Clipboard=M,e.ClipboardPluginElectron=B,e.Device=H,e.DevicePluginElectron=V,e.Filesystem=$,e.FilesystemPluginElectron=z,e.Modals=Q,e.ModalsPluginElectron=J,e.Network=ee,e.NetworkPluginElectron=Z,e.Plugins=m,e.SplashScreen=re,e.SplashScreenPluginElectron=te,e.WebPlugin=P,e.WebPluginRegistry=g,e.WebPlugins=b,e.mergeWebPlugin=E,e.mergeWebPlugins=S,e.registerElectronPlugin=e=>{E(m,e)},Object.defineProperty(e,"__esModule",{value:!0}),e}({});